

#### Getting Started

The code runs on Python 3 with Tensorflow version 1 (>=1.13). To install the dependencies, run
```
pip3 install -r requirements.txt
```

Then, download the datasets manually and put them into the `datasets` folder.
- For MNIST dataset, download from <http://yann.lecun.com/exdb/mnist/> and put the standalone files into `datasets/mnist`.
- For CIFAR-10 dataset, download the "CIFAR-10 binary version (suitable for C programs)" from <https://www.cs.toronto.edu/~kriz/cifar.html>, extract the standalone `*.bin` files and put them into `datasets/cifar-10-batches-bin`.
- For Fashion-MNIST dataset, download from https://github.com/zalandoresearch/fashion-mnist

To test the code: 
- Run `server.py` and wait until you see `Waiting for incoming connections...` in the console output.
- Run some parallel instances of "client.py"/"fedprox_client.py"/"fedadm_client.py" on the same machine as the server. 
- You will see console outputs on both the server and clients indicating message exchanges. 

#### Code Structure

All configuration options are given in `config.py` which also explains the different setups that the code can run with.

The results are saved as CSV files in the `results` folder. 
The CSV files should be deleted before starting a new round of experiment.
Otherwise, the new results will be appended to the existing file.

Currently, the supported datasets are MNIST(MNIST-O,MNIST-F) and CIFAR-10, and the supported models are SVM and CNN. The code can be extended to support other datasets and models too.  

### GPU Support

2 RTX 4090 and 6 RTX 2080 Ti GPUs were used for the experiments. 

CUDA: 10.0
cuDNN: 7.4
python 3.7
